/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.algorithms;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import java.util.Iterator;
import javax.annotation.Nullable;

public class WpMatMergeIterator
extends AbstractIterator<WorkplaceActivity> {
    private final PeekingIterator<WorkplaceActivity> wpIter;
    private final PeekingIterator<OfflineActivity> matIter;
    private long t;

    public WpMatMergeIterator(Iterator<WorkplaceActivity> wpIter, Iterator<OfflineActivity> matIter) {
        this.wpIter = Iterators.peekingIterator(wpIter);
        this.matIter = Iterators.peekingIterator(matIter);
        this.t = Long.MIN_VALUE;
    }

    @Nullable
    private WorkplaceActivity peekCandidate(PeekingIterator<? extends WorkplaceActivity> iter) {
        WorkplaceActivity nextWpa = null;
        while (iter.hasNext() && (nextWpa = iter.peek()).getEnd() <= this.t) {
            iter.next();
            nextWpa = null;
        }
        return nextWpa;
    }

    private WorkplaceActivity nextWp() {
        WorkplaceActivity wpa = this.wpIter.next();
        if (wpa.getStart() < this.t) {
            Preconditions.checkState(wpa instanceof Bubble);
            wpa.setStart(this.t);
        }
        this.t = wpa.getEnd();
        return wpa;
    }

    private WorkplaceActivity nextMat() {
        WorkplaceActivity wpa = this.matIter.next();
        if (wpa.getStart() < this.t) {
            wpa.setStart(this.t);
        }
        this.t = wpa.getEnd();
        return wpa;
    }

    private OfflineActivity offline(long start, long end) {
        this.wpIter.next();
        this.t = end;
        return new OfflineActivity(start, end, null, true);
    }

    @Override
    protected WorkplaceActivity computeNext() {
        WorkplaceActivity wpAct = this.peekCandidate(this.wpIter);
        WorkplaceActivity matAct = this.peekCandidate(this.matIter);
        if (wpAct == null && matAct == null || this.t == Long.MAX_VALUE) {
            return (WorkplaceActivity)this.endOfData();
        }
        if (wpAct == null) {
            return this.nextMat();
        }
        if (matAct == null) {
            return this.nextWp();
        }
        long wpS = Math.max(this.t, wpAct.getStart());
        long matS = Math.max(this.t, matAct.getStart());
        long wpE = wpAct.getEnd();
        long matE = matAct.getEnd();
        if (wpS >= matE) {
            return this.nextMat();
        }
        if (matS >= wpE) {
            return this.nextWp();
        }
        Preconditions.checkState(matS >= wpS, "Workplace iterator has holes between activities.");
        if (wpAct instanceof Bubble) {
            if (wpS < matS) {
                this.t = matS;
                return new Bubble(wpS, matS, wpAct.getWorkplace());
            }
            if (wpE > matE) {
                return this.nextMat();
            }
            return this.offline(wpS, wpE);
        }
        if (wpAct instanceof CumulativeWorkplaceActivity) {
            return this.offline(wpS, wpE);
        }
        return this.nextWp();
    }
}

